<?php
/**
 * mainfin functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package mainfin
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function mainfin_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on mainfin, use a find and replace
		* to change 'mainfin' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'mainfin', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'mainfin' ),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'mainfin_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'mainfin_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function mainfin_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'mainfin_content_width', 640 );
}
add_action( 'after_setup_theme', 'mainfin_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function mainfin_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'mainfin' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'mainfin' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'mainfin_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function mainfin_scripts() {
	wp_enqueue_style( 'mainfin-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'mainfin-style', 'rtl', 'replace' );

	wp_enqueue_script( 'mainfin-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'mainfin_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}
define('ALLOW_UNFILTERED_UPLOADS', true);

function cc_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');


function my_list(){
    $snippet_pt_args = array(
         'labels' => array(
          'name' => 'List',
          'singular_name' => 'Custom List',
        ),
      'supports'      => array( 'title', 'thumbnail' ),
      'public' => false,
      'menu_icon'   => 'dashicons-welcome-write-blog',
      'show_ui' => true,
      'label'     => 'My Custom List'
    );
    
  register_post_type( 'list', $snippet_pt_args);
}
add_action('init', 'my_list');

/**
 * Мой кастомный код для вывода на странице поста следующих постов BEGIN
 */
function show_next_x_posts_links_by_id() {
    global $post; // Получаем текущий пост

    // Получаем ID всех опубликованных постов
    $all_posts_ids = get_posts(array(
        'post_type' => 'post',
        'post_status' => 'publish',
        'numberposts' => -1, // Получаем все посты
        'fields' => 'ids', // Возвращаем только ID
        'orderby' => 'ID',
        'order' => 'ASC'
    ));

    // Находим текущий индекс в массиве
    $current_index = array_search($post->ID, $all_posts_ids);

    // Собираем массив из 50 следующих ID
    $next_ids = array_slice($all_posts_ids, $current_index + 1, 50);

    // Если следующих постов меньше 50, добавляем посты с начала списка
    if (count($next_ids) < 50) {
        $remaining = 50 - count($next_ids);
        $next_ids = array_merge($next_ids, array_slice($all_posts_ids, 0, $remaining));
    }

    if (!empty($next_ids)) {
        echo '<ul class="next-posts-links">';
        foreach ($next_ids as $next_id) {
            $post_title = get_the_title($next_id);
            $post_url = get_permalink($next_id);
            echo '<li><a href="' . esc_url($post_url) . '">' . esc_html($post_title) . '</a></li>';
        }
        echo '</ul>';
    } else {
        echo 'No next posts.';
    }
}

function show_next_x_posts_links_by_id_shortcode() {
    ob_start(); // Начинаем буферизацию вывода
    show_next_x_posts_links_by_id(); // Вызываем функцию вывода постов
    return ob_get_clean(); // Возвращаем содержимое буфера и очищаем его
}

add_shortcode('next_x_posts', 'show_next_x_posts_links_by_id_shortcode');


/**
 * Мой кастомный код для вывода на странице поста следующих постов END
 */


/**********ACF Options Page *****************/
if( function_exists('acf_add_options_page') ) {
	acf_add_options_page(array(
		'page_title' 	=> 'Theme General Settings',
		'menu_title'	=> 'Theme Settings',
		'menu_slug' 	=> 'theme-general-settings',
		'capability'	=> 'edit_posts',
		'redirect'		=> false
	));	
}